`timescale 100ps / 10ps

/*
 * Options for modeling byte transmission (uncomment at most 1)
 * - SUHDCHK_ZHD
 *   - Line is released (data=HiZ) after hold time
 * - SUHDCK_CKFE
 *   - Data is set during falling edge of CLK, line released at falling edge
 *     of CLK
 * - default (no option uncommented)
 *   - Data is set to 0 after hold time, line released (tCL-tSU) after
 *     last falling edge of CLK
 *
 */
//`define SUHDCHK_ZHD
`define SUHDCHK_CKFE

module stimulus 
	(
    IO,
    CLK1,
    CLK2,
		CS1n,
		CS2n,
    HBP,
    HTBSEL
	);

  inout [7:0] IO;
	
	output CS1n, CS2n;
	output CLK1, CLK2;
  output reg [2:0] HBP = 3'b000;
  output reg HTBSEL = 0;
        
	reg CSn = 1;
	reg CLK = 0;
        
	reg SI_IO0_reg=0;
  reg SO_IO1_reg=0;
  reg WPn_IO2_reg=0;
  reg IO3_reg=0;

  reg [3:0] tx;
  reg sel_dev;

  parameter SPI = 3'h1;
  parameter DPI = 3'h2;
  parameter QPI = 3'h4;

  wire SI_IO0;
  wire SO_IO1;
  wire WPn_IO2;
  wire IO3;

  /* Register Addresses */
  localparam ADDR_SR  = 32'h0;
  localparam ADDR_ISR = 32'h1;
  localparam ADDR_CR1 = 32'h2;
  localparam ADDR_CR2 = 32'h3;
  localparam ADDR_INTCR = 32'h4;
  localparam ADDR_ECCDIR = 32'h5;
  localparam ADDR_ECCEIR = 32'h6;
  localparam ADDR_ECCDOR = 32'h7;
  localparam ADDR_ECCECR = 32'h8;
  localparam ADDR_ID  = 32'h30;
  localparam ADDR_UID = 32'h40;
  localparam ADDR_SN  = 32'h50;

  /* Address protect */
`ifdef DENSITY_1G // 1Gb Dual -> 512Mb per lane
  localparam ARRAY_BYTES = 32'h4000000;
  localparam UPPER_1_64 = 32'h3F00000;
  localparam UPPER_1_32 = 32'h3E00000;
  localparam UPPER_1_16 = 32'h3C00000;
  localparam UPPER_1_8  = 32'h3800000;
  localparam UPPER_1_4  = 32'h3000000;
  localparam UPPER_1_2  = 32'h2000000;
  localparam LOWER_1_64 = 32'h00FFFFF;
  localparam LOWER_1_32 = 32'h01FFFFF;
  localparam LOWER_1_16 = 32'h03FFFFF;
  localparam LOWER_1_8  = 32'h07FFFFF;
  localparam LOWER_1_4  = 32'h0FFFFFF;
  localparam LOWER_1_2  = 32'h1FFFFFF;
`elsif DENSITY_2G // 2Gb Dual -> 1Gb per lane
  localparam ARRAY_BYTES = 32'h8000000;
  localparam UPPER_1_64 = 32'h7E00000;
  localparam UPPER_1_32 = 32'h7C00000;
  localparam UPPER_1_16 = 32'h7800000;
  localparam UPPER_1_8  = 32'h7000000;
  localparam UPPER_1_4  = 32'h6000000;
  localparam UPPER_1_2  = 32'h4000000;
  localparam LOWER_1_64 = 32'h01FFFFF;
  localparam LOWER_1_32 = 32'h03FFFFF;
  localparam LOWER_1_16 = 32'h07FFFFF;
  localparam LOWER_1_8  = 32'h0FFFFFF;
  localparam LOWER_1_4  = 32'h1FFFFFF;
  localparam LOWER_1_2  = 32'h3FFFFFF;
`elsif DENSITY_4G // 4Gb Dual -> 2Gb per lane
  localparam ARRAY_BYTES = 32'h10000000;
  localparam UPPER_1_64 = 32'hFC00000;
  localparam UPPER_1_32 = 32'hF800000;
  localparam UPPER_1_16 = 32'hF000000;
  localparam UPPER_1_8  = 32'hE000000;
  localparam UPPER_1_4  = 32'hC000000;
  localparam UPPER_1_2  = 32'h8000000;
  localparam LOWER_1_64 = 32'h03FFFFF;
  localparam LOWER_1_32 = 32'h07FFFFF;
  localparam LOWER_1_16 = 32'h0FFFFFF;
  localparam LOWER_1_8  = 32'h1FFFFFF;
  localparam LOWER_1_4  = 32'h3FFFFFF;
  localparam LOWER_1_2  = 32'h7FFFFFF;
`elsif DENSITY_8G // 8Gb Dual -> 4Gb per lane
  localparam ARRAY_BYTES = 32'h20000000;
  localparam UPPER_1_64 = 32'h1F800000;
  localparam UPPER_1_32 = 32'h1F000000;
  localparam UPPER_1_16 = 32'h1E000000;
  localparam UPPER_1_8  = 32'h1C000000;
  localparam UPPER_1_4  = 32'h18000000;
  localparam UPPER_1_2  = 32'h10000000;
  localparam LOWER_1_64 = 32'h07FFFFF;
  localparam LOWER_1_32 = 32'h0FFFFFF;
  localparam LOWER_1_16 = 32'h1FFFFFF;
  localparam LOWER_1_8  = 32'h3FFFFFF;
  localparam LOWER_1_4  = 32'h7FFFFFF;
  localparam LOWER_1_2  = 32'hFFFFFFF;
`else // 8Gb Dual -> 4Gb per lane
  localparam ARRAY_BYTES = 32'h20000000;
  localparam UPPER_1_64 = 32'h1F800000;
  localparam UPPER_1_32 = 32'h1F000000;
  localparam UPPER_1_16 = 32'h1E000000;
  localparam UPPER_1_8  = 32'h1C000000;
  localparam UPPER_1_4  = 32'h18000000;
  localparam UPPER_1_2  = 32'h10000000;
  localparam LOWER_1_64 = 32'h07FFFFF;
  localparam LOWER_1_32 = 32'h0FFFFFF;
  localparam LOWER_1_16 = 32'h1FFFFFF;
  localparam LOWER_1_8  = 32'h3FFFFFF;
  localparam LOWER_1_4  = 32'h7FFFFFF;
  localparam LOWER_1_2  = 32'hFFFFFFF;
`endif

  `include "task.v"
  
  assign IO[0] = (tx[0] && sel_dev==1'b0) ? SI_IO0_reg : 1'bz;  
  assign IO[1] = (tx[1] && sel_dev==1'b0) ? SO_IO1_reg : 1'bz;  
  assign IO[2] = (tx[2] && sel_dev==1'b0) ? WPn_IO2_reg : 1'bz;  
  assign IO[3] = (tx[3] && sel_dev==1'b0) ? IO3_reg : 1'bz;  
  assign IO[4] = (tx[0] && sel_dev==1'b1) ? SI_IO0_reg : 1'bz;  
  assign IO[5] = (tx[1] && sel_dev==1'b1) ? SO_IO1_reg : 1'bz;  
  assign IO[6] = (tx[2] && sel_dev==1'b1) ? WPn_IO2_reg : 1'bz;  
  assign IO[7] = (tx[3] && sel_dev==1'b1) ? IO3_reg : 1'bz;  
  assign CLK1 = (sel_dev==1'b0) ? CLK : 0;
  assign CLK2 = (sel_dev==1'b1) ? CLK : 0;
  assign CS1n = (sel_dev==1'b0) ? CSn : 1'b1;
  assign CS2n = (sel_dev==1'b1) ? CSn : 1'b1;

  assign SI_IO0  = (sel_dev == 1'b0) ? IO[0] : IO[4];
  assign SO_IO1  = (sel_dev == 1'b0) ? IO[1] : IO[5];
  assign WPn_IO2 = (sel_dev == 1'b0) ? IO[2] : IO[6];
  assign IO3     = (sel_dev == 1'b0) ? IO[3] : IO[7];

  initial begin
    tx = 4'd0;
    sel_dev = 0;
    #10000;

    /* Top block protect, All */
    $display("==== [TEST] Top block protect: All ====");
    WriteEnable(SPI);
    WriteStatus(SPI, 8'h0);
    WriteEnable(SPI);
    //WriteConfig(SPI, 8'h0, 8'h08, 8'h0, 8'h01);
    WriteSeq(SPI, 32'h1234, 8'h50, 8'h7, 24'd4);
    ReadSeq(SPI, 32'h1234, 8'h50, 8'h7, 24'd4);

    WriteEnable(SPI);
    WriteStatus(SPI, {2'h0, 1'b0, 3'b111, 2'h0});
    WriteSeq(SPI, 32'h1234, 8'hB0, 8'h7, 24'd4);
    ReadSeq(SPI, 32'h1234, 8'hB0, 8'h7, 24'd4); // 4 errors

    /* Top block protect, Upper 1/2 */
    $display("==== [TEST] Top block protect: Upper 1/2 (2Gb, 1Gb per dev)  ====");
    WriteEnable(SPI);
    WriteStatus(SPI, 8'h0);
    WriteEnable(SPI);
    //WriteConfig(SPI, 8'h0, 8'h08, 8'h0, 8'h01);
    WriteSeq(SPI, UPPER_1_2 - 32'h2, 8'h50, 8'h7, 24'd4);
    ReadSeq(SPI, UPPER_1_2 - 32'h2, 8'h50, 8'h7, 24'd4);

    WriteEnable(SPI);
    WriteStatus(SPI, {2'h0, 1'b0, 3'b110, 2'h0});
    WriteSeq(SPI, UPPER_1_2 - 32'h2, 8'hB0, 8'h7, 24'd4);
    ReadSeq(SPI, UPPER_1_2 - 32'h2, 8'hB0, 8'h7, 24'd4);

    /* Top block protect, Upper 1/4 */
    $display("==== [TEST] Top block protect: Upper 1/4 (2Gb, 1Gb per dev)  ====");
    WriteEnable(SPI);
    WriteStatus(SPI, 8'h0);
    WriteEnable(SPI);
    //WriteConfig(SPI, 8'h0, 8'h08, 8'h0, 8'h01);
    WriteSeq(SPI, UPPER_1_4-32'h2, 8'h50, 8'h7, 24'd4);
    ReadSeq(SPI, UPPER_1_4-32'h2, 8'h50, 8'h7, 24'd4);

    WriteEnable(SPI);
    WriteStatus(SPI, {2'h0, 1'b0, 3'b101, 2'h0});
    WriteSeq(SPI, UPPER_1_4-32'h2, 8'hB0, 8'h7, 24'd4);
    ReadSeq(SPI, UPPER_1_4-32'h2, 8'hB0, 8'h7, 24'd4);

    /* Top block protect, Upper 1/8 */
    $display("==== [TEST] Top block protect: Upper 1/8 (2Gb, 1Gb per dev)  ====");
    WriteEnable(SPI);
    WriteStatus(SPI, 8'h0);
    WriteEnable(SPI);
    //WriteConfig(SPI, 8'h0, 8'h08, 8'h0, 8'h01);
    WriteSeq(SPI, UPPER_1_8-32'h2, 8'h50, 8'h7, 24'd4);
    ReadSeq(SPI, UPPER_1_8-32'h2, 8'h50, 8'h7, 24'd4);

    WriteEnable(SPI);
    WriteStatus(SPI, {2'h0, 1'b0, 3'b100, 2'h0});
    WriteSeq(SPI, UPPER_1_8-32'h2, 8'hB0, 8'h7, 24'd4);
    ReadSeq(SPI, UPPER_1_8-32'h2, 8'hB0, 8'h7, 24'd4);

    /* Top block protect, Upper 1/16 */
    $display("==== [TEST] Top block protect: Upper 1/16 (2Gb, 1Gb per dev)  ====");
    WriteEnable(SPI);
    WriteStatus(SPI, 8'h0);
    WriteEnable(SPI);
    //WriteConfig(SPI, 8'h0, 8'h08, 8'h0, 8'h01);
    WriteSeq(SPI, UPPER_1_16-32'h2, 8'h50, 8'h7, 24'd4);
    ReadSeq(SPI, UPPER_1_16-32'h2, 8'h50, 8'h7, 24'd4);

    WriteEnable(SPI);
    WriteStatus(SPI, {2'h0, 1'b0, 3'b011, 2'h0});
    WriteSeq(SPI, UPPER_1_16-32'h2, 8'hB0, 8'h7, 24'd4);
    ReadSeq(SPI, UPPER_1_16-32'h2, 8'hB0, 8'h7, 24'd4);

    /* Top block protect, Upper 1/32 */
    $display("==== [TEST] Top block protect: Upper 1/32 (2Gb, 1Gb per dev)  ====");
    WriteEnable(SPI);
    WriteStatus(SPI, 8'h0);
    WriteEnable(SPI);
    //WriteConfig(SPI, 8'h0, 8'h08, 8'h0, 8'h01);
    WriteSeq(SPI, UPPER_1_32-32'h2, 8'h50, 8'h7, 24'd4);
    ReadSeq(SPI, UPPER_1_32-32'h2, 8'h50, 8'h7, 24'd4);

    WriteEnable(SPI);
    WriteStatus(SPI, {2'h0, 1'b0, 3'b010, 2'h0});
    WriteSeq(SPI, UPPER_1_32-32'h2, 8'hB0, 8'h7, 24'd4);
    ReadSeq(SPI, UPPER_1_32-32'h2, 8'hB0, 8'h7, 24'd4);

    /* Top block protect, Upper 1/64 */
    $display("==== [TEST] Top block protect: Upper 1/64 (2Gb, 1Gb per dev)  ====");
    WriteEnable(SPI);
    WriteStatus(SPI, 8'h0);
    WriteEnable(SPI);
    //WriteConfig(SPI, 8'h0, 8'h08, 8'h0, 8'h01);
    WriteSeq(SPI, UPPER_1_64-32'h2, 8'h50, 8'h7, 24'd4);
    ReadSeq(SPI, UPPER_1_64-32'h2, 8'h50, 8'h7, 24'd4);

    WriteEnable(SPI);
    WriteStatus(SPI, {2'h0, 1'b0, 3'b001, 2'h0});
    WriteSeq(SPI, UPPER_1_64-32'h2, 8'hB0, 8'h7, 24'd4);
    ReadSeq(SPI, UPPER_1_64-32'h2, 8'hB0, 8'h7, 24'd4);

    /* Bottom block protect, All */
    $display("==== [TEST] Bottom block protect: All ====");
    WriteEnable(SPI);
    WriteStatus(SPI, 8'h0);
    WriteEnable(SPI);
    //WriteConfig(SPI, 8'h0, 8'h08, 8'h0, 8'h01);
    WriteSeq(SPI, 32'h1fabcd, 8'h66, 8'h7, 24'd4);
    ReadSeq(SPI, 32'h1fabcd, 8'h66, 8'h7, 24'd4);

    WriteEnable(SPI);
    WriteStatus(SPI, {2'h0, 1'b1, 3'b111, 2'h0});
    WriteSeq(SPI, 32'h1fabcd, 8'hC6, 8'h7, 24'd4);
    ReadSeq(SPI, 32'h1fabcd, 8'hC6, 8'h7, 24'd4);

    /* Bottom block protect, Lower 1/2 */
    $display("==== [TEST] Bottom block protect: Lower 1/2 (2Gb, 1Gb per dev) ====");
    WriteEnable(SPI);
    WriteStatus(SPI, 8'h0);
    WriteEnable(SPI);
    //WriteConfig(SPI, 8'h0, 8'h08, 8'h0, 8'h01);
    WriteSeq(SPI, LOWER_1_2-32'h1, 8'h66, 8'h7, 24'd4);
    ReadSeq(SPI, LOWER_1_2-32'h1, 8'h66, 8'h7, 24'd4);

    WriteEnable(SPI);
    WriteStatus(SPI, {2'h0, 1'b1, 3'b110, 2'h0});
    WriteSeq(SPI, LOWER_1_2-32'h1, 8'hC6, 8'h7, 24'd4);
    ReadSeq(SPI, LOWER_1_2-32'h1, 8'hC6, 8'h7, 24'd4);

    /* Bottom block protect, Lower 1/4 */
    $display("==== [TEST] Bottom block protect: Lower 1/4 (2Gb, 1Gb per dev) ====");
    WriteEnable(SPI);
    WriteStatus(SPI, 8'h0);
    WriteEnable(SPI);
    //WriteConfig(SPI, 8'h0, 8'h08, 8'h0, 8'h01);
    WriteSeq(SPI, LOWER_1_4-32'h1, 8'h66, 8'h7, 24'd4);
    ReadSeq(SPI, LOWER_1_4-32'h1, 8'h66, 8'h7, 24'd4);

    WriteEnable(SPI);
    WriteStatus(SPI, {2'h0, 1'b1, 3'b101, 2'h0});
    WriteSeq(SPI, LOWER_1_4-32'h1, 8'hC6, 8'h7, 24'd4);
    ReadSeq(SPI, LOWER_1_4-32'h1, 8'hC6, 8'h7, 24'd4);

    /* Bottom block protect, Lower 1/8 */
    $display("==== [TEST] Bottom block protect: Lower 1/8 (2Gb, 1Gb per dev) ====");
    WriteEnable(SPI);
    WriteStatus(SPI, 8'h0);
    WriteEnable(SPI);
    //WriteConfig(SPI, 8'h0, 8'h08, 8'h0, 8'h01);
    WriteSeq(SPI, LOWER_1_8-32'h1, 8'h66, 8'h7, 24'd4);
    ReadSeq(SPI, LOWER_1_8-32'h1, 8'h66, 8'h7, 24'd4);

    WriteEnable(SPI);
    WriteStatus(SPI, {2'h0, 1'b1, 3'b100, 2'h0});
    WriteSeq(SPI, LOWER_1_8-32'h1, 8'hC6, 8'h7, 24'd4);
    ReadSeq(SPI, LOWER_1_8-32'h1, 8'hC6, 8'h7, 24'd4);

    /* Bottom block protect, Lower 1/16 */
    $display("==== [TEST] Bottom block protect: Lower 1/16 (2Gb, 1Gb per dev) ====");
    WriteEnable(SPI);
    WriteStatus(SPI, 8'h0);
    WriteEnable(SPI);
    //WriteConfig(SPI, 8'h0, 8'h08, 8'h0, 8'h01);
    WriteSeq(SPI, LOWER_1_16-32'h1, 8'h66, 8'h7, 24'd4);
    ReadSeq(SPI, LOWER_1_16-32'h1, 8'h66, 8'h7, 24'd4);

    WriteEnable(SPI);
    WriteStatus(SPI, {2'h0, 1'b1, 3'b011, 2'h0});
    WriteSeq(SPI, LOWER_1_16-32'h1, 8'hC6, 8'h7, 24'd4);
    ReadSeq(SPI, LOWER_1_16-32'h1, 8'hC6, 8'h7, 24'd4);

    /* Bottom block protect, Lower 1/32 */
    $display("==== [TEST] Bottom block protect: Lower 1/32 (2Gb, 1Gb per dev) ====");
    WriteEnable(SPI);
    WriteStatus(SPI, 8'h0);
    WriteEnable(SPI);
    //WriteConfig(SPI, 8'h0, 8'h08, 8'h0, 8'h01);
    WriteSeq(SPI, LOWER_1_32-32'h1, 8'h66, 8'h7, 24'd4);
    ReadSeq(SPI, LOWER_1_32-32'h1, 8'h66, 8'h7, 24'd4);

    WriteEnable(SPI);
    WriteStatus(SPI, {2'h0, 1'b1, 3'b010, 2'h0});
    WriteSeq(SPI, LOWER_1_32-32'h1, 8'hC6, 8'h7, 24'd4);
    ReadSeq(SPI, LOWER_1_32-32'h1, 8'hC6, 8'h7, 24'd4);

    /* Bottom block protect, Lower 1/64 */
    $display("==== [TEST] Bottom block protect: Lower 1/64 (2Gb, 1Gb per dev) ====");
    WriteEnable(SPI);
    WriteStatus(SPI, 8'h0);
    WriteEnable(SPI);
    //WriteConfig(SPI, 8'h0, 8'h08, 8'h0, 8'h01);
    WriteSeq(SPI, LOWER_1_64-32'h1, 8'h66, 8'h7, 24'd4);
    ReadSeq(SPI, LOWER_1_64-32'h1, 8'h66, 8'h7, 24'd4);

    WriteEnable(SPI);
    WriteStatus(SPI, {2'h0, 1'b1, 3'b001, 2'h0});
    WriteSeq(SPI, LOWER_1_64-32'h1, 8'hC6, 8'h7, 24'd4);
    ReadSeq(SPI, LOWER_1_64-32'h1, 8'hC6, 8'h7, 24'd4);

    /* HW Bottom block protect, Lower 1/64 */
    $display("==== [TEST] HW Bottom block protect: Lower 1/64 (2Gb, 1Gb per dev) ====");
    {HTBSEL, HBP} = 4'b0000;
    WriteEnable(SPI);
    WriteStatus(SPI, 8'h0);
    WriteEnable(SPI);
    //WriteConfig(SPI, 8'h0, 8'h08, 8'h0, 8'h01);
    WriteSeq(SPI, LOWER_1_64-32'h1, 8'h66, 8'h7, 24'd4);
    ReadSeq(SPI, LOWER_1_64-32'h1, 8'h66, 8'h7, 24'd4);

    {HTBSEL, HBP} = 4'b1001;
    WriteSeq(SPI, LOWER_1_64-32'h1, 8'hC6, 8'h7, 24'd4);
    ReadSeq(SPI, LOWER_1_64-32'h1, 8'hC6, 8'h7, 24'd4);

    /* HW Bottom block protect, Upper 1/16 */
    $display("==== [TEST] HW Top block protect: Upper 1/16 (2Gb, 1Gb per dev) ====");
    {HTBSEL, HBP} = 4'b0000;
    WriteEnable(SPI);
    WriteStatus(SPI, 8'h0);
    WriteEnable(SPI);
    //WriteConfig(SPI, 8'h0, 8'h08, 8'h0, 8'h01);
    WriteSeq(SPI, UPPER_1_16-32'h2, 8'h66, 8'h7, 24'd4);
    ReadSeq(SPI, UPPER_1_16-32'h2, 8'h66, 8'h7, 24'd4);

    {HTBSEL, HBP} = 4'b0011;
    WriteSeq(SPI, UPPER_1_16-32'h2, 8'hC6, 8'h7, 24'd4);
    ReadSeq(SPI, UPPER_1_16-32'h2, 8'hC6, 8'h7, 24'd4);

    $finish;
  end
endmodule
